<div class="form-group {{ $field['class'] }}">
     <label for="{{ $field['name'] }}">{{ $field['label'] }}</label>
    <div class="dropzone mb-3" id="dropzonefileUpload" > </div>
</div>
@php
$images = (App\Models\Setting::where('name',$field['name'])->first()) ? App\Models\Setting::where('name',$field['name'])->first()->images()->get() : [];
@endphp
@push('scripts')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.1/min/dropzone.min.css">
<style>
    .dropzone .dz-preview .dz-image img {
        width: 100%;
        height: 100%;
    }
    .colors{
        background:#eee;
        padding:5px;
    }
</style>

@endpush
@push('scripts')
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.5.1/min/dropzone.min.js"></script>
<script type="text/javascript">
     Dropzone.autoDiscover = false;

    $(document).ready(function() {

         $('.dropzone').dropzone({
            url:"{{ aurl('upload/gallery/'.$field['setting_id'] ) }}",
            pramName:'file',
            uploadMultiple:true,
            maxFiles:15,
            maxFilesSize:2, //mb
            acceptedFiles:'image/*',
            dictDefaultMessage:'{{ trans('crud.upload_files') }}',
            dictRemoveFile:'<span class="btn btn-danger btn-sm mt-3"><i class="fa fa-trash"></i></span>',
            params:{
                _token:'{{ csrf_token() }}',
            },
            addRemoveLinks:true,
            dictRemoveFileConfirmation: '{{trans("crud.are_you_sure")}}',
            removedfile:function(file){
                $.ajax({
                    dataType:'json',
                    type:'post',
                    url:'{{ aurl('upload/gallery/delete/image' ) }}',
                    data:{ _token:'{{ csrf_token() }}' , id: file.FileId }
                });
            var fmock;
            return (fmock = file.previewElement ) != null ? fmock.parentNode.removeChild(file.previewElement):void 0;
            },
            init:function(){

                 @foreach($images as $file)
                var mock = { FileId:'{{ $file->id }}' ,name:'{{ $file->name }}',size:'{{ $file->size }}', type:'{{ $file->mime_type }}' };
                this.emit('addedfile',mock);
                this.emit("complete", mock);
                this.options.thumbnail.call(this,mock, '{{ $file->full_file }}' );
                @endforeach

                this.on('sending',function(file,xhr,formData){
                    formData.append('Fid','');
                    file.Fid = '';
                });

                this.on('success',function(file,response){
                    file.Fid = response.id;
                });
            }

        });
    });
</script>
@endpush