<?php
ini_set('session.gc_maxlifetime', 315360000);
session_set_cookie_params(315360000);
session_start();

// Block access if not logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: loginnnm.php');
    exit;
}

$successMessage = '';

$baseDir = __DIR__ . '/../verifyfiles';
$files = glob($baseDir . '/*/*.html');

// قراءة الملفات المعدلة مسبقًا
$editedFiles = file_exists(__DIR__ . '/edited.log') ? file(__DIR__ . '/edited.log', FILE_IGNORE_NEW_LINES) : [];
$editedFiles = array_filter($editedFiles, 'file_exists'); // نتأكد إن الملفات لسه موجودة

// البحث
$search = isset($_GET['search']) ? strtolower(trim($_GET['search'])) : '';
if ($search !== '') {
    $editedFiles = array_filter($editedFiles, function($file) use ($search) {
        return strpos(strtolower($file), $search) !== false;
    });
}

// ترتيب النتائج
sort($editedFiles);

// التقسيم للصفحات
$totalFiles = count($editedFiles);
$perPage = 50;
$totalPages = ceil($totalFiles / $perPage);
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, min($page, $totalPages));

$start = ($page - 1) * $perPage;
$currentFiles = array_slice($editedFiles, $start, $perPage);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['filepath'], $_POST['new_name'], $_POST['new_content'])) {
    $filePath = $_POST['filepath'];
    $newName = basename($_POST['new_name']);
    $newContent = $_POST['new_content'];

    // ✅ الحماية: ممنوع أكواد PHP أو JS أو system calls
    $dangerous = ['<?php', '<?=','<script', 'eval', 'system', 'exec', 'shell_exec', 'base64_decode', 'passthru'];
    foreach ($dangerous as $word) {
        if (stripos($newContent, $word) !== false) {
            die("❌ المحتوى يحتوي على كود ضار غير مسموح.");
        }
    }

    // ✅ الحماية: ممنوع إدخال صور أو محتوى ثنائي
    if (preg_match('/\x00|\xFF|\xD8|\x89PNG|\x25PDF/i', $newContent)) {
        die("❌ غير مسموح بإدخال محتوى غير نصي مثل الصور أو الملفات الثنائية.");
    }

    // ✅ الحماية: الحد الأقصى 120 حرف
    if (mb_strlen($newContent, 'UTF-8') > 120) {
        die("❌ لا يمكن كتابة أكثر من 120 حرف في الملف.");
    }

    if (file_exists($filePath)) {
        file_put_contents($filePath, $newContent);

        $newPath = dirname($filePath) . '/' . $newName;
        if ($filePath !== $newPath) {
            rename($filePath, $newPath);
        }

        $successMessage = "✅ File updated successfully.";
    } else {
        echo "<p style='color:red;'>❌ File not found</p>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>📂 Edited Files</title>
        <meta name="robots" content="noindex, nofollow">
    <style>
        body { font-family: Arial; }
        .file-box { border: 1px solid #ccc; margin: 10px 0; padding: 10px; background: #e0ffe0; }
        textarea { width: 100%; height: 100px; }
        .pagination a { margin: 0 5px; text-decoration: none; }
        .pagination strong { margin: 0 5px; }
        .success-message {
            background-color: #d4edda;
            color: #155724;
            padding: 10px;
            border-left: 5px solid #28a745;
            margin-bottom: 15px;
            font-weight: bold;
        }
    </style>
    <script>
        // Hide message after 5 seconds
        setTimeout(() => {
            const msg = document.getElementById("success-msg");
            if (msg) msg.style.display = "none";
        }, 5000);
    </script>
</head>
<body>
    <a href="logoutnnm.php" style="float:right; color:red;">🚪 Logout</a>

    <h2>📂 Edited Files</h2>
    <a href="indexnnm.php">🔙 Back to All Files</a>
    <br><br>

    <?php if ($successMessage): ?>
        <div class="success-message" id="success-msg"><?= $successMessage ?></div>
    <?php endif; ?>

    <!-- Search Form -->
    <form method="GET" action="editednnm.php">
        <input type="text" name="search" placeholder="🔍 Search domain..." value="<?= htmlspecialchars($search) ?>">
        <button type="submit">Search</button>
    </form>

    <p>Total files: <?= $totalFiles ?> | Page <?= $page ?> of <?= $totalPages ?></p>

    <?php foreach ($currentFiles as $file): ?>
        <?php $fileContent = htmlspecialchars(file_get_contents($file)); ?>
        <div class="file-box">
            <form method="POST">
                <p><strong><?= basename(dirname($file)) ?>/<?= basename($file) ?></strong></p>
                <input type="hidden" name="filepath" value="<?= htmlspecialchars($file) ?>">
                <label>New name:</label><br>
                <input type="text" name="new_name" value="<?= basename($file) ?>" required><br><br>
                <label>Content:</label><br>
                <textarea name="new_content" required><?= $fileContent ?></textarea><br><br>
                <button type="submit">💾 Save Changes</button>
            </form>
        </div>
    <?php endforeach; ?>

    <!-- Pagination -->
    <div class="pagination">
        <?php if ($page > 1): ?>
            <a href="?page=<?= $page - 1 ?>&search=<?= urlencode($search) ?>">⬅️ Previous</a>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <?php if ($i == $page): ?>
                <strong><?= $i ?></strong>
            <?php else: ?>
                <a href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
            <?php endif; ?>
        <?php endfor; ?>

        <?php if ($page < $totalPages): ?>
            <a href="?page=<?= $page + 1 ?>&search=<?= urlencode($search) ?>">Next ➡️</a>
        <?php endif; ?>
    </div>
</body>
</html>
