<?php

namespace App\Http\Controllers\API;

use App\Domain\Core\Models\Faq;
use App\Domain\Core\Models\Setting;
use App\Domain\Core\Models\Slider;
use App\Domain\Offer\Models\Offer;
use App\Http\Resources\API\Core\FaqResource;
use App\Http\Resources\API\Core\SliderResource;
use App\Http\Resources\API\Offer\OfferResource;
use Carbon\Carbon;

class HomeController extends ApiController
{
    public function getGeneratedTitle()
    {
        $lang = request('lang'); // Get the language from the request
        $pageName = request('page_name'); // Get the page name from the request

        // Construct the file path
        $dir = resource_path('views/frontend/'.$lang.'/json_files/titles/'.$pageName.'.json');

        // Check if the file exists
        if (!file_exists($dir)) {
            return response()->json(['error' => 'File not found'], 404);
        }

        // Read and decode the JSON file
        $jsonContent = file_get_contents($dir);

        $data = json_decode($jsonContent, true); // Decode JSON as an associative array

        if (empty($data)) {
            return $this->sendError(__('JSON file is empty'), 400);
        }
        if($data){
            // Return the data
            return  $this->sendResponse($data,__($pageName));
        }else{
            // Return the data
            return  $this->sendError('no data found');
        }
    }
    public function getGeneratedDescription()
    {
        $lang = request('lang'); // Get the language from the request
        $pageName = request('page_name'); // Get the page name from the request

        // Construct the file path
        $dir = resource_path('views/frontend/'.$lang.'/json_files/descriptions/'.$pageName.'.json');

        // Check if the file exists
        if (!file_exists($dir)) {
            return $this->sendError('File not found');
        }

        // Read and decode the JSON file
        $jsonContent = file_get_contents($dir);
        $data = json_decode($jsonContent, true); // Decode JSON as an associative array
        if($data){
            // Return the data
            return  $this->sendResponse($data,__($pageName));
        }else{
            // Return the data
            return  $this->sendError('no data found');
        }

    }
    public function getGeneratedChangeByCommand()
    {
        $lang = request('lang'); // Get the language from the request
        $pageName = request('page_name'); // Get the page name from the request

        // Construct the file path
        $dir = resource_path('views/frontend/'.$lang.'/json_files/change_by_command/'.$pageName.'.json');

        // Check if the file exists
        if (!file_exists($dir)) {
            return $this->sendError('File not found');
        }

        // Read and decode the JSON file
        $jsonContent = file_get_contents($dir);
        $data = json_decode($jsonContent, true); // Decode JSON as an associative array
        if($data){
            // Return the data
            return  $this->sendResponse($data,__($pageName));
        }else{
            // Return the data
            return  $this->sendError('no data found');
        }

    }

    public function deleteTitleAfterTaken()
    {
        $lang = request('lang'); // Get the language from the request
        $pageName = request('page_name'); // Get the page name from the request
        // Construct the file path
        $filePath = resource_path('views/frontend/'.$lang.'/json_files/titles/'.$pageName.'.json');
        // Check if the file exists
        if (!file_exists($filePath)) {
            return $this->sendError('File not found');
        }
        // Read and decode the JSON file
        $jsonContent = file_get_contents($filePath);
        $data = json_decode($jsonContent, true); // Decode JSON as an associative array
        // Check if JSON is valid
        if (json_last_error() !== JSON_ERROR_NONE) {
            return $this->sendError('Invalid JSON format');
        }
        // Get the first key
        $firstKey = array_key_first($data);
        // Check if there is any data
        if ($firstKey === null) {
            return $this->sendError('JSON file is empty');
        }
        // Copy the first column
        $copiedData = $data[$firstKey];
        // Remove the first column from the JSON data
        unset($data[$firstKey]);
        // Write the updated JSON back to the file
        file_put_contents($filePath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        // Return the copied data
        $this->sendSuccess(__('deleted successfully'));
    }
    public function deleteDescriptionAfterTaken()
    {
        $lang = request('lang'); // Get the language from the request
        $pageName = request('page_name'); // Get the page name from the request
        // Construct the file path
        $filePath = resource_path('views/frontend/'.$lang.'/json_files/descriptions/'.$pageName.'.json');
        // Check if the file exists
        if (!file_exists($filePath)) {
            return $this->sendError('File not found');
        }
        // Read and decode the JSON file
        $jsonContent = file_get_contents($filePath);
        $data = json_decode($jsonContent, true); // Decode JSON as an associative array
        // Check if JSON is valid
        if (json_last_error() !== JSON_ERROR_NONE) {
            return $this->sendError('Invalid JSON format');
        }
        // Get the first key
        $firstKey = array_key_first($data);
        // Check if there is any data
        if ($firstKey === null) {
            return $this->sendError('JSON file is empty');
        }
        // Copy the first column
        $copiedData = $data[$firstKey];
        // Remove the first column from the JSON data
        unset($data[$firstKey]);
        // Write the updated JSON back to the file
        file_put_contents($filePath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        // Return the copied data
        $this->sendSuccess(__('deleted successfully'));
    }
    public function deleteChangeByCommandAfterTaken()
    {
        $lang = request('lang'); // Get the language from the request
        $pageName = request('page_name'); // Get the page name from the request
        // Construct the file path
        $filePath = resource_path('views/frontend/'.$lang.'/json_files/change_by_command/'.$pageName.'.json');
        // Check if the file exists
        if (!file_exists($filePath)) {
            return $this->sendError('File not found');
        }
        // Read and decode the JSON file
        $jsonContent = file_get_contents($filePath);
        $data = json_decode($jsonContent, true); // Decode JSON as an associative array
        // Check if JSON is valid
        if (json_last_error() !== JSON_ERROR_NONE) {
            return $this->sendError('Invalid JSON format');
        }
        // Get the first key
        $firstKey = array_key_first($data);
        // Check if there is any data
        if ($firstKey === null) {
            return $this->sendError('JSON file is empty');
        }
        // Copy the first column
        $copiedData = $data[$firstKey];
        // Remove the first column from the JSON data
        unset($data[$firstKey]);
        // Write the updated JSON back to the file
        file_put_contents($filePath, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        // Return the copied data
        $this->sendSuccess(__('deleted successfully'));
    }
}
