<?php

namespace App\Domain\Core\Datatables;

use App\Domain\Core\Models\Slider;
use App\Support\Dashboard\Datatables\BaseDatatable;
use App\Support\Dashboard\Datatables\Columns\ImageColumn;
use App\Support\Dashboard\Datatables\Columns\VideoColumn;
use Illuminate\Database\Eloquent\Builder;
use LanguageListClass;
use Yajra\DataTables\Html\Column;

class SliderDatatable extends BaseDatatable
{
    public function query(): Builder
    {
        return Slider::query();
    }

    protected function columns(): array
    {
        return [
            Column::make('active')->title(__('Active')),
            Column::make('start_at')->title(__('Start At')),
            Column::make('end_at')->title(__('End At')),
            Column::computed('image')->title(__('Background')),
        ];
    }

    protected function customColumns(): array
    {
        return [
            'image' => function ($model) {
                return ImageColumn::render($model->getFirstMediaUrl('image'));
            },
        ];
    }

}
